<?php
// Mulai output buffering untuk menangani pengalihan
ob_start();

function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

function getISP($ip) {
    $access_token = '72158e01413fb2'; // Ganti dengan akses token ipinfo.io Anda
    $url = "https://ipinfo.io/{$ip}/json?token={$access_token}";
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Tambahkan opsi SSL untuk keamanan
    curl_setopt($ch, CURLOPT_TIMEOUT, 5); // Timeout setelah 5 detik

    $output = curl_exec($ch);
    curl_close($ch);

    $details = json_decode($output, true);
    return $details['org'] ?? 'Unknown ISP';
}

function loadAllowedISPs($filename) {
    if (!file_exists($filename)) {
        die('File daftar ISP yang diizinkan tidak ditemukan.');
    }

    $allowedISPs = file($filename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    return $allowedISPs;
}

function loadBlockedIPs($filename) {
    if (!file_exists($filename)) {
        die('File daftar IP yang diblokir tidak ditemukan.');
    }

    $blockedIPs = file($filename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    return $blockedIPs;
}

function logAccess($logfile, $ip, $isp) {
    $date = date('Y-m-d H:i:s');
    $entry = "[{$date}] {$ip} - {$isp}" . PHP_EOL;
    file_put_contents($logfile, $entry, FILE_APPEND | LOCK_EX);
}

function loadURLs($filename) {
    if (!file_exists($filename)) {
        // Default URLs jika file tidak ditemukan
        return [
            'allowed_url' => 'https://elitespacevantage.com/',
            'denied_url' => 'https://elitespacevantage.com/'
        ];
    }

    $config = json_decode(file_get_contents($filename), true);
    return $config;
}

function isBlockedIP($blockedIPs, $ip) {
    foreach ($blockedIPs as $blockedIP) {
        if (strpos($ip, $blockedIP) === 0) { // Memeriksa apakah IP dimulai dengan prefix yang diblokir
            return true;
        }
    }
    return false;
}

function allowISP($allowedISPs, $blockedIPs, $accessLog, $deniedLog, $configFile) {
    $ip = getUserIP();
    $config = loadURLs($configFile);

    // Periksa apakah IP diblokir
    if (isBlockedIP($blockedIPs, $ip)) {
        // Log akses untuk IP yang diblokir
        logAccess($deniedLog, $ip, 'Blocked IP');

        // Redirect ke elitespacevantage.com jika IP diblokir
        header('Location: https://elitespacevantage.com/');
        exit();
    }

    $userISP = getISP($ip);

    $isAllowed = false;
    foreach ($allowedISPs as $allowedISP) {
        if (stripos($userISP, $allowedISP) !== false) {
            $isAllowed = true;
            break;
        }
    }

    if (!$isAllowed) {
        // Log akses untuk IP yang tidak diizinkan
        logAccess($deniedLog, $ip, $userISP);

        // Redirect ke halaman penolakan jika ISP tidak diizinkan
        header('Location: ' . $config['denied_url']);
        exit();
    } else {
        // Log akses untuk IP yang diizinkan
        logAccess($accessLog, $ip, $userISP);

        // Redirect ke halaman yang diizinkan jika ISP diizinkan
        header('Location: ' . $config['allowed_url']);
        exit();
    }
}

// Nama file yang berisi daftar ISP yang diizinkan
$allowedISPsFile = 'allowed_isps.txt';

// Nama file yang berisi daftar awalan IP yang diblokir
$blockedIPsFile = 'ip.txt';

// Nama file log akses
$accessLog = 'access_log.txt';

// Nama file log penolakan akses
$deniedLog = 'denied_log.txt';

// File konfigurasi URL
$configFile = 'urls.json';

try {
    // Memuat daftar ISP yang diizinkan dari file
    $allowedISPs = loadAllowedISPs($allowedISPsFile);

    // Memuat daftar awalan IP yang diblokir
    $blockedIPs = loadBlockedIPs($blockedIPsFile);

    allowISP($allowedISPs, $blockedIPs, $accessLog, $deniedLog, $configFile);
} catch (Exception $e) {
    // Jika terjadi error, redirect ke elitespacevantage.com
    header('Location: https://elitespacevantage.com/');
    exit();
}

// Konten fallback jika terjadi kesalahan (opsional)
echo 'Memuat konten...';

// Akhiri output buffering dan kirimkan output ke browser
ob_end_flush();
?>