<!DOCTYPE html>
<html>
<head>
    <title>Login</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background: url('images/background.jpg') no-repeat center center fixed; /* Gantilah 'images/background.jpg' dengan path gambar Anda */
            background-size: cover;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .login-container {
            background: rgba(255, 255, 255, 0.9);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            width: 350px;
            text-align: center;
        }
        h2 { 
            margin-bottom: 30px; 
            color: #333; 
            font-size: 24px; 
        }
        input[type="text"], input[type="password"] {
            width: calc(100% - 20px);
            padding: 15px;
            margin: 10px 0;
            border: 1px solid #ccc;
            border-radius: 25px;
            box-sizing: border-box;
            transition: all 0.3s ease;
        }
        input[type="text"]:focus, input[type="password"]:focus {
            border-color: #50b3a2;
            box-shadow: 0 0 8px rgba(80, 179, 162, 0.5);
        }
        input[type="submit"] {
            width: 100%;
            padding: 15px;
            background: #50b3a2;
            border: 0;
            border-radius: 25px;
            color: #fff;
            font-size: 18px;
            cursor: pointer;
            transition: background 0.3s ease;
        }
        input[type="submit"]:hover { 
            background: #333; 
        }
        .error { 
            color: red; 
            text-align: center; 
            margin-bottom: 10px; 
            font-size: 14px; 
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>Login</h2>
        <?php if (isset($_GET['error'])): ?>
            <p class="error">Username atau password salah!</p>
        <?php endif; ?>
        <form action="authenticate.php" method="post">
            <input type="text" name="username" placeholder="Username" required aria-label="Username">
            <input type="password" name="password" placeholder="Password" required aria-label="Password">
            <input type="submit" value="Login">
        </form>
    </div>
</body>
</html>
