<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.php');
    exit();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Dashboard Akses ISP</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: url('images/background.jpg') no-repeat center center fixed; /* Gantilah 'images/background.jpg' dengan path gambar Anda */
            background-size: cover;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .dashboard-container {
            background: rgba(255, 255, 255, 0.9);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            width: 80%;
            max-width: 800px;
            text-align: center;
            height: 80vh;
            overflow-y: auto;
        }
        h2 { 
            margin-bottom: 30px; 
            color: #333; 
            font-size: 24px; 
        }
        ul {
            list-style: none;
            padding: 0;
            max-height: 200px; /* Atur tinggi tetap untuk daftar */
            overflow-y: auto; /* Aktifkan scroll */
        }
        ul li {
            background: #e0e0e0;
            margin: 5px 0;
            padding: 10px;
            border-radius: 5px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        a.button, form input[type="submit"], button {
            display: inline-block;
            padding: 10px 20px;
            background: #50b3a2;
            color: #fff;
            text-decoration: none;
            border-radius: 25px;
            border: none;
            cursor: pointer;
            transition: background 0.3s ease;
        }
        a.button:hover, form input[type="submit"]:hover, button:hover {
            background: #333;
            color: #fff;
        }
        textarea {
            width: 100%;
            height: 100px;
            margin-bottom: 20px;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-family: Arial, sans-serif;
        }
        .result {
            word-wrap: break-word;
            padding: 10px;
            background-color: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        .footer {
            margin-top: 20px;
            font-size: 14px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <h2>Valid ISP</h2>
        <ul>
            <?php
            $accessLog = 'access_log.txt';
            if (file_exists($accessLog)) {
                $logEntries = file($accessLog, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                foreach ($logEntries as $entry) {
                    list($ip, $isp) = explode(' ', $entry, 2); // Mengambil IP dan ISP dari entry log
                    echo "<li>" . htmlspecialchars($ip) . " - " . htmlspecialchars($isp) . "</li>";
                }
            } else {
                echo "<li>Tidak ada ISP yang diizinkan.</li>";
            }
            ?>
        </ul>
        
        <h2>BOT</h2>
        <ul>
            <?php
            $deniedLog = 'denied_log.txt';
            if (file_exists($deniedLog)) {
                $logEntries = file($deniedLog, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                foreach ($logEntries as $entry) {
                    list($ip, $isp) = explode(' ', $entry, 2); // Mengambil IP dan ISP dari entry log
                    echo "<li>" . htmlspecialchars($ip) . " - " . htmlspecialchars($isp) . "</li>";
                }
            } else {
                echo "<li>Tidak ada ISP yang ditolak.</li>";
            }
            ?>
        </ul>

        <h2>URL Shortener</h2>
        <textarea id="longUrl" placeholder="Enter URL here..."></textarea>
        <button onclick="shortenUrl()">Shorten URL</button>
        <div class="result" id="shortUrlResult"></div>
        
        <h2>Short URLs</h2>
        <ul id="shortUrlList">
            <?php
            $urlLog = 'url.txt';
            if (file_exists($urlLog)) {
                $logEntries = file($urlLog, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                foreach ($logEntries as $entry) {
                    list($shortCode, $longUrl) = explode(' ', $entry, 2); // Mengambil kode pendek dan URL asli dari log
                    $shortUrl = "https://activetrade247.com/" . htmlspecialchars($shortCode); // Ganti dengan domain Anda
                    echo "<li id='$shortCode'>Short: <a href='" . $shortUrl . "'>" . $shortUrl . "</a> <button onclick=\"deleteUrl('$shortCode')\">Delete</button></li>";
                }
            } else {
                echo "<li>Tidak ada URL pendek yang dibuat.</li>";
            }
            ?>
        </ul>
        
        <a href="index.php" class="button">Kembali ke Halaman Utama</a>
        <form action="reset_logs.php" method="post">
            <input type="submit" value="Reset Logs">
        </form>
        <div class="footer">
            2024 Ghost.id. All rights reserved.
        </div>
    </div>
    <script>
        function shortenUrl() {
            const longUrl = document.getElementById('longUrl').value;
            const xhr = new XMLHttpRequest();
            xhr.open("POST", "shorten_url.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onreadystatechange = function () {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    const shortUrl = xhr.responseText;
                    document.getElementById('shortUrlResult').innerText = shortUrl;

                    // Tambahkan URL pendek baru ke daftar
                    const ul = document.getElementById('shortUrlList');
                    const li = document.createElement('li');
                    li.id = shortUrl.split('/').pop();
                    li.innerHTML = "Short: <a href='" + shortUrl + "'>" + shortUrl + "</a> <button onclick=\"deleteUrl('" + li.id + "')\">Delete</button>";
                    ul.appendChild(li);
                }
            };
            xhr.send("url=" + encodeURIComponent(longUrl));
        }

        function deleteUrl(shortCode) {
            const xhr = new XMLHttpRequest();
            xhr.open("POST", "delete_url.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onreadystatechange = function () {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    if (xhr.responseText === 'success') {
                        const li = document.getElementById(shortCode);
                        li.parentNode.removeChild(li);
                    } else {
                        alert('Failed to delete URL');
                    }
                }
            };
            xhr.send("shortCode=" + encodeURIComponent(shortCode));
        }
    </script>
</body>
</html>